/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.overlay;

import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import dev.xkmc.youkaishomecoming.content.pot.overlay.TileTooltip;
import dev.xkmc.youkaishomecoming.util.JEIFluidStackRenderer;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public record TileClientTooltip(List<ItemStack> items, List<FluidStack> fluids, int width, int height) implements ClientTooltipComponent
{
    public TileClientTooltip(TileTooltip inv) {
        this(inv.items(), inv.fluids(), inv.w(), inv.h());
    }

    private int size() {
        return this.items().size() + this.fluids().size();
    }

    public int m_142103_() {
        return this.height * 18 + 2;
    }

    public int m_142069_(Font font) {
        return this.width * 18 + 2;
    }

    public void m_183452_(Font font, int mx, int my, GuiGraphics g) {
        int x;
        int y;
        int w = this.width;
        int n = 0;
        for (ItemStack itemStack : this.items) {
            if (itemStack.m_41619_()) continue;
            y = my + n / w * 18 + 1;
            x = mx + n % w * 18 + 1;
            this.renderSlot(font, x, y, g, itemStack);
            ++n;
        }
        for (FluidStack fluidStack : this.fluids) {
            if (fluidStack.isEmpty()) continue;
            y = my + n / w * 18 + 1;
            x = mx + n % w * 18 + 1;
            Fluid fluid = fluidStack.getFluid();
            if (fluid instanceof YHFluid) {
                YHFluid sake = (YHFluid)fluid;
                this.renderSlot(font, x, y, g, sake.type.asStack(fluidStack.getAmount() / sake.type.amount()));
            } else {
                this.renderSlot(font, x, y, g, fluidStack);
            }
            ++n;
        }
    }

    private void renderSlot(Font font, int x, int y, GuiGraphics g, ItemStack stack) {
        if (!stack.m_41619_()) {
            g.m_280256_(stack, x + 1, y + 1, 0);
            g.m_280370_(font, stack, x + 1, y + 1);
        }
    }

    private void renderSlot(Font font, int x, int y, GuiGraphics g, FluidStack stack) {
        if (!stack.isEmpty()) {
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)(x + 1), (float)(y + 1), 0.0f);
            new JEIFluidStackRenderer().render(g, stack);
            g.m_280168_().m_85849_();
        }
    }
}

